//
//  BITimerManager.h
//  BIViews
//
//  Created by Eric Hochmeister on 06/04/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class BITimeSlip;
@class BIDatabaseObjectContext;

/*!
    @class       BITimerManager
    @abstract    The Timer Manager manages timed slips which are actively being timed.
    @discussion  Timer Manager is a singleton.
 
                 It keeps track of actively timed slips.  It is responsible for telling these slips to increment their times, pausing themselves and starting themselves.  It handles when the system goes idle, by pausing all slips.
 
                 If you need to interact with a slip which is being timed, you should be going through the Timer Manager rather than directly interacting with the slip itself.
*/


@interface BITimerManager : NSObject {
		
	NSMutableArray* _activeTimedSlips;
	NSTimeInterval _intervalDuration;
    NSArray* activeSlipsWhenIdle;
    
//    BIDatabaseObjectContext* _objectContext;  // weak ref
	
}

+ (id)defaultInstance;

//- (BIDatabaseObjectContext*)objectContext;
//- (void)setObjectContext:(BIDatabaseObjectContext*)oc;

- (NSMutableArray *)activeTimedSlips;
- (void)setActiveTimedSlips:(NSMutableArray *)anActiveTimedSlips;
- (int)numberOfActiveTimedSlips;
- (NSTimeInterval)intervalDuration;
- (void)setIntervalDuration:(NSTimeInterval)anIntervalDuration;

- (BOOL)addSlip:(BITimeSlip*)aSlip;
- (BOOL)removeSlip:(BITimeSlip*)aSlip;

- (void)stopAllTimers;

- (void)refreshCachedDurations;

- (void)handleMachineIsIdle:(NSNotification*)aNotif;
//- (void)handleMachineIsActive:(NSNotification*)aNotif;

- (NSArray*)activeSlipsWhenIdle;
- (void)setActiveSlipsWhenIdle:(NSArray*)theSlips;

- (void)startTimersForActiveSlipsWhenIdle;
- (void)stopTimersForActiveSlipsWhenIdle;

@end
